package centralSystem.counters;

import centralSystem.ICentralSystem;
import centralSystem.IPostCounter;

/**
 * {@link OneServiceCounter} is a constant-service implementation 
 * of {@link IPostCounter} interface. Once chosen the service to work 
 * with there's no reason for the counter to change service. 
 * 
 * @author simone
 *
 */
public class OneServiceCounter implements IPostCounter {

	private ICentralSystem centralSys;
	private int serviceType;
	
	public OneServiceCounter(ICentralSystem centralSys, int serviceType) {
		this.centralSys = centralSys;
		this.serviceType = serviceType;
	}
	
	@Override
	/*
	 * (non-Javadoc)
	 * @see centralSystem.IPostCounter#nextService()
	 */
	public int nextService() {
		centralSys.clientServedAtQueue(serviceType);
		return serviceType;
	}

	@Override
	public int getHandled() {
		return serviceType;
	}

}
